<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0 RC2
// ||              
// ||             .
// ||       (  )
// || tranlated by: arabsdesign.com
// || www.arabsdesign.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

$specialtemplates = array(
	'adv_gallery_opt',
	'gallery_c_cache',
);

$phrasegroups = array(
	'adv_gallery',
	'adv_gallery_cp'
);

require_once('./global.php');
require_once('./includes/functions_gallery.php');
require_once('./includes/adminfunctions_gallery.php');

$vba_options = unserialize($datastore['adv_gallery_opt']);
$categorycache = unserialize($datastore['gallery_c_cache']);

unset($datastore['adv_gallery_opt'], $datastore['gallery_c_cache']);

print_cp_header($vbphrase['vba_gallery_admin']);

// ############################## Validate Images #############################
if ($_REQUEST['do'] == 'validateimages')
{
	globalize($_REQUEST, array('showlarge' => INT));

	print_form_header('vba_gallery', 'dovalidateimages');
	print_table_header(construct_phrase($vbphrase['x_awaiting_moderation'], $vbphrase['images']));

	$getimages = $DB_site->query("
			SELECT images.*, user.email
			FROM " . TABLE_PREFIX . "adv_gallery_images AS images
			LEFT JOIN " . TABLE_PREFIX . "user AS user USING (userid)
			WHERE valid = 0 
			ORDER BY dateline
	");

	if ($DB_site->num_rows($getimages))
	{
		print_description_row('
			<div style="float:' . $stylevar['right'] . '">
			<label for="sendmailcheck">' . $vbphrase['send_email'] . ' <input checked="checked" id="sendmailcheck" name="allbox" onclick="js_check_all(this.form);" type="checkbox" /></label></div>
			<label for="checkall1"><input checked="checked" id="checkall1" name="checkall" onclick="js_check_all_option(this.form, \'1\');" type="radio" /> ' . $vbphrase[validate_all] . '</label>
			<label for="checkall2"><input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, \'2\');" type="radio" /> ' . $vbphrase['delete_all'] . '</label>
			<label for="checkall0"><input id="checkall0" name="checkall" onclick="js_check_all_option(this.form, 0);" type="radio" /> ' . $vbphrase['ignore_all'] . '</label><br /><br />
			' . construct_link_code(iif($showlarge, $vbphrase['show_thumbnails'], $vbphrase['show_large_images']), 'vba_gallery.php?do=validateimages' . iif(!$showlarge, '&amp;showlarge=1')), '', '', 'thead', 'center');
		print_table_break();

		$catselect = construct_categories($categorycache, 0, -1);

		$custominfo = array();
		$customfields = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_customfields ORDER BY displayorder");
		while ($field = $DB_site->fetch_array($customfields))
		{
			$custominfo[] = $field;
		}
		$DB_site->free_result($customfields);
		unset($field);

		while ($images = $DB_site->fetch_array($getimages))
		{

			if (!is_category_mod($image['catid']))
			{
				continue;
			}

			$modcount++;

		  print_table_header('<span style="float:' . $stylevar['right'] . '">(' . iif($images['userid'], '<a href="' . $vboptions['bburl'] . '/member.php?' . $session['sessionurl'] . 'u=' . $images['userid'] . '" target="_blank">' . $images['username'] . '</a>', $vbphrase['unregistered']) . ') &nbsp; ' . vbdate($vboptions['dateformat'] . ' '  . $vboptions['timeformat'], $images['dateline']) . '</span>' . stripslashes($images['title']), 2, 0, '', 'left');

			print_description_row('<center><a href="' . $vba_options['gallery_fileurl'] . '/' . implode('/', preg_split('//', $images['userid'], -1, PREG_SPLIT_NO_EMPTY)) . '/' . $images['filename'] . '" target="_blank" ><img border="0" alt="' . $images['title'] . '" src="' . construct_image_url($images, iif($showlarge, 'filename', 'thumbname')) . '" /></a></center>');

			construct_hidden_code("email[$images[imageid]]", $images['email']);
			construct_hidden_code("dateline[$images[imageid]]", $images['dateline']);
			construct_hidden_code("username[$images[imageid]]", $images['username']);
			construct_hidden_code("userid[$images[imageid]]", $images['userid']);
			construct_hidden_code("imagecat[$images[imageid]]", $images['catid']);
			construct_hidden_code("filename[$images[imageid]]", $images['filename']);
			construct_hidden_code("thumbname[$images[imageid]]", $images['thumbname']);

			print_input_row("$vbphrase[title]:", "title[$images[imageid]]", unhtmlspecialchars(stripslashes($images['title'])));
			print_textarea_row("$vbphrase[description]:", "desc[$images[imageid]]", unhtmlspecialchars(stripslashes($images['description'])), 4, 36);

			print_category_select("catid[$images[imageid]]", $images['catid'], '', $vbphrase['category']);

			print_input_row("$vbphrase[keywords]:", "keywords[$images[imageid]]", unhtmlspecialchars(stripslashes($images['keywords'])));
			print_input_row("$vbphrase[views]:", "views[$images[imageid]]", $images['views']);
			print_input_row("$vbphrase[image_notes]:", "notes[$images[imageid]]", $images['notes']);

			construct_custom_fieldbits($images, $custominfo, true, true, true);

			print_label_row($vbphrase['action'], '
			<div style="float:' . $stylevar['right'] . '"><label for="sendmail_' . $images['imageid'] . '">' . $vbphrase['send_email'] . ' <input checked="checked" id="sendmail_' . $images['imageid'] . '" name="sendmail[' . $images['imageid'] . ']" type="checkbox" value="1" /></label></div>
				<label for="valimage_' . $images['imageid'] . '"><input checked="checked" id="valimage_' . $images['imageid'] . '" name="validateimage[' . $images['imageid'] . ']" type="radio" value="1" />' . $vbphrase['validate'] . '</label>
				<label for="delimage_' . $images['imageid'] . '"><input id="delimage_' . $images['imageid'] . '" name="validateimage[' . $images['imageid'] . ']" type="radio" value="2" />' . $vbphrase['delete'] . '</label>
				<label for="ignimage_' . $images['imageid'] . '"><input id="ignimage_' . $images['imageid'] . '" name="validateimage[' . $images['imageid'] . ']" type="radio" value="0" />' . $vbphrase['ignore'] . '</label>
			', 'thead');

			print_table_break();
		}
		print_submit_row();
		
	}

	if (!$modcount)
	{
		print_description_row('<b>' . construct_phrase($vbphrase['no_x_awaiting_moderation'], $vbphrase['images']) . '</b>', '', '', '', 'center');
		print_table_footer();
	}

}

// ############################# Do Validate New Images #######################
if ($_POST['do'] == 'dovalidateimages')
{
	globalize($_POST, array('email', 'dateline', 'username', 'userid', 'title', 'desc', 'catid', 'keywords', 'views', 'notes', 'sendmail', 'validateimage', 'imagecat', 'thumbname', 'filename'));

	validate_new_images($validateimage);

	print_cp_redirect("vba_gallery.php?$session[sessionurl]do=validateimages", 0);
}

// ########################## Validate New Posts ##############################
if ($_REQUEST['do'] == 'validateposts')
{
  print_form_header('vba_gallery', 'dovalidateposts');
  print_table_header(construct_phrase($vbphrase['x_awaiting_moderation'], $vbphrase['posts']));

	$posts = $DB_site->query("
			SELECT posts.*, images.catid, images.title
			FROM " . TABLE_PREFIX . "adv_gallery_posts AS posts
			LEFT JOIN " . TABLE_PREFIX . "adv_gallery_images AS images USING (imageid)
			WHERE posts.visible = 0 ORDER BY dateline
	");
	if ($DB_site->num_rows($posts))
	{
		$counter = 0;
		print_description_row('
			<label for="checkall1"><input checked="checked" id="checkall1" name="checkall" onclick="js_check_all_option(this.form, \'1\');" type="radio" /> ' . $vbphrase[validate_all] . '</label>
			<label for="checkall2"><input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, \'2\');" type="radio" /> ' . $vbphrase['delete_all'] . '</label>
			<label for="checkall0"><input id="checkall0" name="checkall" onclick="js_check_all_option(this.form, 0);" type="radio" /> ' . $vbphrase['ignore_all'] . '</label>', '', '', 'thead', 'center');
		print_table_break();
		while ($post = $DB_site->fetch_array($posts))
		{
			$counter = 1;
			if (!is_category_mod($post['catid']))
			{
				continue;
			}
		  print_table_header('<span style="float:' . $stylevar['right'] . '">(' . iif($post['userid'], '<a href="' . $vboptions['bburl'] . '/member.php?' . $session['sessionurl'] . 'u=' . $post['userid'] . '" target="_blank">' . $post['username'] . '</a>', $vbphrase['unregistered']) . ') &nbsp; ' . vbdate($vboptions['dateformat'] . ' ' . $vboptions['timeformat'], $post['dateline']) . '</span><a href="' . $vba_options['gallery_url'] . '/showimage.php?i=' . $post['imageid'] . '" target="_blank">' . stripslashes($post['title']) . '</a>', 2, 0, '', 'left');
			construct_hidden_code('imageid[' . $post['postid'] . ']', $post['imageid']);
			construct_hidden_code('catid[' . $post['postid'] . ']', $post['catid']);
			construct_hidden_code('userid[' . $post['postid'] . ']', $post['userid']);
			construct_hidden_code('username[' . $post['postid'] . ']', $post['username']);
			construct_hidden_code('dateline[' . $post['postid'] . ']', $post['dateline']);
			construct_hidden_code('userid[' . $post['postid'] . ']', $post['userid']);
		
			print_input_row($vbphrase['title'] . ':', 'title[' . $post['postid'] . ']', unhtmlspecialchars(stripslashes($post['title'])));
			print_textarea_row($vbphrase['message'] . ':', 'message[' . $post['postid'] . ']', unhtmlspecialchars(stripslashes($post['pagetext'])), 4, 36);

			print_label_row($vbphrase['action'], '
				<label for="valpost_' . $post['postid'] . '"><input checked="checked" id="valpost_' . $post['postid'] . '" name="validatepost[' . $post['postid'] . ']" type="radio" value="1" />' . $vbphrase['validate'] . '</label>
				<label for="delpost_' . $post['postid'] . '"><input id="delpost_' . $post['postid'] . '" name="validatepost[' . $post['postid'] . ']" type="radio" value="2" />' . $vbphrase['delete'] . '</label>
				<label for="ignpost_' . $post['postid'] . '"><input id="ignpost_' . $post['postid'] . '" name="validatepost[' . $post['postid'] . ']" type="radio" value="0" />' . $vbphrase['ignore'] . '</label>
			', 'thead');

			print_table_break();
		}
		print_submit_row();
	}

	if (!$counter)
	{
		print_description_row('<b>' . construct_phrase($vbphrase['no_x_awaiting_moderation'], $vbphrase['posts']) . '</b>', '', '', '', 'center');
		print_table_footer();
	}
}

// ############################# Do Validate New Posts #########################
if ($_POST['do'] == 'dovalidateposts')
{
	globalize($_POST, array('imageid', 'catid', 'userid', 'username', 'dateline', 'title', 'message', 'validatepost', 'userid'));

	validate_new_posts($validatepost);

	print_cp_redirect("vba_gallery.php?$session[sessionurl]&do=validateposts", 0);
}

print_cp_footer();

?>